# Ripen language overview

This applies to Ripen version 3.2, current as of 14 February 2024.

At a basic level, Ripen works like most similar languages:

	? 3 2 + . cr
	5
	ok
	? :squared dup * ;
	ok
	? 3 2 + squared . cr
	25
	ok

Note the lack of a space after the colon: Ripen doesn't use parsing words, instead relying on sigils to achieve similar functionality. E.g. variables work like this:

	? 3 2 - =a
	ok
	? $a . cr
	1
	ok

On the minus side, there are no proper quoted strings; words in parentheses are simply joined by a space. Note that the closing paren is a word too, so it *must* be space-separated itself, on both sides:

	? ( Hello,  world! ) .. cr
	Hello, world!
	ok

Now, comments! Like in other Forths, a backslash introduces comments that last to the end of the line:

```
	2 3 2dup + -rot * < . cr \ Test if 2 + 3 < 2 * 3
```

On the other hand, block comments are C-style. They're also executable statements, so you'll want to leave them on the outside of word definitions:

	? /* s -- */ :say .. cr ;
	ok
	? ( Hello, world! ) say
	Hello, world!
	ok

Last but not least, control structures are inspired by Logo, to make them a lot more readable than in other stack-based languages:

```
	? 3 2 + 3 2 * < [ ( Yes! ) .. cr ] iftrue
	Yes!
	ok
	? { $i . } 3 times cr
	0 1 2 
	ok
```

You can use either square brackets or else curly braces to delimit lists of words, that control structures treat as blocks of code. The reason both are provided is that lists of the same kind can't nest.

## Vocabulary

When defining a word, beware that it will overwrite an older definition by the same name if it exists, and the entire script will see the new one right away.

Otherwise, Ripen only provides a minimum of vocabulary:

- arithmetic: +, -, *, /, mod, /mod, negate, abs, min, max, 1+, 1-;
- comparisons and logic =, <>, <, <=, >, >=, and, or, not;
- stack manipulation: drop, dup, over, 2dup, swap, rot, -rot, clear;

and a few more conveniences.  Enter `words` for a complete list.

### Sigils and aliases

In addition to words, Ripen has sigils. Each sigil is one character placed at the start of another word, that changes how it's handled. Besides $, = and : there are also + and - (add to and subtract from a variable), / to define a word from a block of code, and ? to show a definition.

As of version 3.0, Ripen also has aliases, that can be used to define constants and synonyms. By default "true" and "false" are defined as 1 and 0, respectively. Aliases are expanded at runtime, anywhere in the code, but they're not recursive.

A Ripen script can define aliases with the @ sigil, but sigils can only be defined from the host language.
