# About the Ripen scripting engine

Welcome to Ripen, a stack-based scripting engine with highly readable syntax, that can be implemented with little code and effort in a language like C++ or Nim. It's informed by RetroForth and PostScript, but diverges from either in important ways, not least due to its string-threaded nature.

Ripen is based on principles explained in the article More About Tiny Scripting Engines. The point is having a single-file engine, easily copy-pasted into any application. For this reason, the default vocabulary is kept small. See the language overview.

## Availability

This document applies to the C++ port of Ripen.

Ripen is a single-header library bundled with a small command-line interpreter.

You might have received a pre-built binary for Linux with this document, but it's only good for a quick test run; Ripen is intended as an extension language.

Binaries are built on a Debian 10 machine, and seem to have decent compatibility with other / older distributions. No promises.

## Building and running

Ripen version 2.x and later is written in C++11, and requires a relatively modern compiler (tested with GCC 8.3.0, but 4.8.x should be enough). It only depends on the standard library. See the makefile included with the source code.

## Performance

The C++ port is smaller but also slower than the Nim port. An informal test was performed with a modified version of the Rugg/Feldman benchmarks (#5), ported like this (yep, it's a one-liner):

	:nop ; { $i 2 / 3 * 4 + 5 - =a nop } 1000 times $a . cr

While timings for this are hard to get on a modern PC, Ripen appears to be faster than Python 2.7, and even Tcl. Of course, both are much more complex.

When the interpreter is itself interpreted, Ripen imposes little overhead, which can make it useful for apps written in Python or Javascript.

## License and support

Ripen is open source software under the Boost Software License 1.0 (see inside).

The easiest way to contact me is via Mastodon, as [@felix@wandering.shop][1]. I'd like to hear from you anyway, but if you have any problems, it's best to open an issue [on Codeberg][2].

[1]: https://wandering.shop/@felix
[2]: https://codeberg.org/nosycat/ripen-cpp
