# About the Ripen scripting engine


Welcome to Ripen, a stack-based scripting engine with highly readable syntax, that can be implemented with little code and effort in a language like C++ or Nim. It's informed by RetroForth and PostScript, but diverges from either in important ways, not least due to its string-threaded nature.

Ripen is based on principles explained in the article More About Tiny Scripting Engines. The point is having a single-file engine, easily copy-pasted into any application. For this reason, the default vocabulary is kept small. See the language overview.

## Availability

This document applies to the Nim port of Ripen, version 3.0 and higher.

Ripen is a single-file library with built-in support for running stand-alone.

You might have received a pre-built binary for Linux with this document, but it's only good for a quick test run; Ripen is intended as an extension language.

Binaries are built on a Debian 10 machine, and seem to have decent compatibility with other / older distributions. No promises.

## Building and running

Ripen is written in Nim (tested with the 1.6 compiler series), and only depends on the Nim standard library. See the build script included with the source code.

Note: this version is incompatible with `-d:danger`! Currently it relies on the ability to catch IndexDefect to detect stack underflows (to be fixed later).

## Performance

The Nim port is larger but also faster than the C++ port. An informal test was performed with a modified version of the Rugg/Feldman benchmarks (#5), ported like this (yep, it's a one-liner):

	:nop ; { $i 2 / 3 * 4 + 5 - =a nop } 1000 times $a . cr

While timings for this are hard to get on a modern PC, Ripen appears to be faster than Python 2.7, and even Tcl. Of course, both are much more complex.

When the interpreter is itself interpreted, Ripen imposes little overhead, which can make it useful for apps written in Python or Javascript.

## License and support

The Nim edition of Ripen is open source software under the MIT License (see the included file). E-mail <felix@plesoianu.ro> if you have feedback or questions.
