#!/usr/bin/env python3

import sys

stack = []
words = {}
sigil = {}

buffer = []
buf_to = None

def interpret(block):
	global buf_to
	for w in block:
		if buf_to != None:
			if w != buf_to:
				buffer.append(w)
			else:
				words[w]()
				buf_to = None
		elif w in words:
			words[w]()
		elif w[0] in sigil:
			sigil[w[0]](w[1:])
		else:
			stack.append(float(w))

class UserWord:
	def __init__(self, code):
		self.code = code
	def __call__(self):
		interpret(self.code)

words["+"] = lambda: stack.append(stack.pop() + stack.pop())
words["*"] = lambda: stack.append(stack.pop() * stack.pop())
words["."] = lambda: print(stack.pop(), end="")
words["space"] = lambda: print(" ", end="")
words["cr"] = lambda: print()

def subtract():
	b = stack.pop()
	a = stack.pop()
	stack.append(a - b)
def power():
	b = stack.pop()
	a = stack.pop()
	stack.append(a ** b)
words["-"] = subtract
words["**"] = power

words[".s"] = lambda: print(stack)
words["depth"] = lambda: stack.append(len(stack))
words["words"] = lambda: print(words.keys())

words["bye"] = lambda: sys.exit()

sigil[">"] = lambda n: words.__setitem__(n, stack.pop())
sigil["$"] = lambda n: stack.append(words[n])

def slash_star():
	global buf_to
	buf_to = "*/"
def star_slash():
	buffer.clear()
words["/*"] = slash_star
words["*/"] = star_slash

def open_bracket():
	global buf_to
	buffer.clear()
	buf_to = "]"
def close_bracket():
	stack.append(buffer.copy())
words["["] = open_bracket
words["]"] = close_bracket

def double_quote():
	global buf_to
	if buf_to == None:
		buffer.clear()
		buf_to = '"'
	else:
		stack.append(" ".join(buffer))
words['"'] = double_quote

def times():
	n = int(stack.pop())
	code = stack.pop()
	for i in range(n):
		words["i"] = i
		interpret(code)
def iftrue():
	code = stack.pop()
	if stack.pop():
		interpret(code)
words["times"] = times
words["iftrue"] = iftrue
words["="] = lambda: stack.append(stack.pop() == stack.pop())

def colon(n):
	global buf_to
	stack.append(n)
	buffer.clear()
	buf_to = ";"
sigil["/"] = lambda n: words.__setitem__(n, UserWord(stack.pop()))
sigil[":"] = colon
words[";"] = lambda: words.__setitem__(
	stack.pop(), UserWord(buffer.copy()))

while True:
	try:
		interpret(input("? ").split())
		print("ok")
	except ValueError as e:
		print("Unknown word:", e, file=sys.stderr)
	except IndexError as e:
		print("Stack underflow", file=sys.stderr)
	except EOFError as e:
		break
