#!/usr/bin/env python3

import sys

stack = []
words = {}
sigil = {}

words["+"] = lambda: stack.append(stack.pop() + stack.pop())
words["*"] = lambda: stack.append(stack.pop() * stack.pop())
words["."] = lambda: print(stack.pop(), end="")
words["space"] = lambda: print(" ", end="")
words["cr"] = lambda: print()

def subtract():
	b = stack.pop()
	a = stack.pop()
	stack.append(a - b)
def power():
	b = stack.pop()
	a = stack.pop()
	stack.append(a ** b)
words["-"] = subtract
words["**"] = power

words[".s"] = lambda: print(stack)
words["depth"] = lambda: stack.append(len(stack))
words["words"] = lambda: print(words.keys())

words["bye"] = lambda: sys.exit()

sigil[">"] = lambda n: words.__setitem__(n, stack.pop())
sigil["$"] = lambda n: stack.append(words[n])

while True:
	try:
		for w in input("? ").split():
			if w in words:
				words[w]()
			elif w[0] in sigil:
				sigil[w[0]](w[1:])
			else:
				stack.append(float(w))
		print("ok")
	except ValueError as e:
		print("Unknown word:", w, file=sys.stderr)
	except IndexError as e:
		print("Stack underflow", file=sys.stderr)
	except EOFError as e:
		break
