#!/usr/bin/env python3

import shlex

stack = []
words = {}

words["+"] = lambda: stack.append(stack.pop() + stack.pop())
words["."] = lambda: print(stack.pop())

class Variable:
	def __init__(self, value = None):
		self.value = value
	def __call__(self):
		stack.append(self)

def make_var():
	words[input_buffer.pop(0)] = Variable()
words["variable"] = make_var
def set_var():
	v = stack.pop()
	v.value = stack.pop()
words["!"] = set_var
words["@"] = lambda: stack.append(stack.pop().value)

class Constant:
	def __init__(self, value):
		self.value = value
	def __call__(self):
		stack.append(self.value)

def make_const():
	words[input_buffer.pop(0)] = Constant(stack.pop())
words["constant"] = make_const

words[".s"] = lambda: print(stack)

words["do"] = lambda: stack.append(input_buffer.pop(0))
def if_true():
	block = stack.pop()
	if stack.pop():
		interpret_string(block)
words["iftrue"] = if_true
def interpret_string(block):
	block = shlex.split(block)
	while len(block) > 0:
		w = block.pop(0)
		if w == "do":
			stack.append(block.pop(0))
		elif w in words:
			words[w]()
		else:
			stack.append(float(w))

while True:
	input_buffer = shlex.split(input("? "))
	while len(input_buffer) > 0:
		w = input_buffer.pop(0)
		if w in words:
			words[w]()
		else:
			stack.append(float(w))
