import timeit
import ripen

print("Timing native code...")
t1 = timeit.timeit(
	"a.append(1237); a.append(6593); a.append(a.pop() + a.pop()); a.pop()",
	"a = []")
print(t1)

print("Timing Ripen...")
t2 = timeit.timeit(
	"ripen.interpret(a)",
	"a = '1237 6593 + drop'.split()",
	globals=globals())
print(t2)

print("Ratio: ", t2 / t1)
