# F-Lower reference guide

This document applies to version 1.3 beta.

## Words

Constants:

	false true

Math:

	1- 1+ + - * / mod negate abs max min ln exp sqrt cos sin trunc round
	random randomize

Logic:

	>= > <> = <= < not or and

I/O:

	. cr ( ) refill include emit space spaces char

Facility extension:

	ms

Stack:

	drop dup swap 2dup over rot -rot pick

Definitions and variables:

	@ ! variable constant value to : ;

Comments:

	/* */ \

Control structures:

	{ } [ ] iffalse iftrue times repeat until while interpret

Interactive use:

	' execute .s words see forget depth bye

## Internals

- F-Lower doesn't have a return stack; it piggybacks on the host language.
- Conversely, it has a word stack so it can handle variables and such.
- Words are stored uniformly; execution tokens are simply callback procedures.
- Similarly, the def_* procedures are just factories that set the right fields.

Compilation state is replaced with a uniform buffering system that also works outside colon definitions, and powers control structures too.
