# F-Lower scripting language

F-Lower is a toy scripting language initially created as a learning project. As such it's limited and doesn't have clear goals yet. It started out as a clone of Ripen (an older interpreter) and retains key traits like string threading or the control structures. Otherwise F-Lower is much simpler, more like a Forth dialect.

## Building and running

F-Lower is written in [Free Pascal][1], using only the Run-Time Library and Free Component Library. If you only received the source code with this file, you can build it with a command like,

	fpc -XX fl.pas

The resulting executable is completely static and should be very portable.

[1]: https://www.freepascal.org/

## Overview

The basics are much like in Forth:

	3.141592 constant PI
	variable diagonal
	: hypot dup * swap dup * + sqrt ;
	3 4 hypot diagonal !
	diagonal @ . cr

Note: F-Lower is case-sensitive and the data stack uses floating point!

	2 3 < { ( Yay! ) cr } iftrue \ Parens print out text.
	{ ( Ho! ) } 3 times cr /* Block comments are like in C instead. */
	1 { ( Hey ) 1+ } while [ dup 3 <= ] repeat drop cr

Control structures on the other hand are more like in Logo. Note that code blocks of the same type can't nest!

For more language constructs see the reference guide.

A word on performance: until version 1.2 beta, F-Lower was several times slower than Ripen. Changing the dictionary implementation to a hash table brought them within 40% of each other, but F-Lower isn't going to win any prizes for speed.

## Frequently Asked Questions

**What was the point of creating F-Lower?**

Mainly it was a pretext to learn Free Pascal. This part was a success.

**What new insights did it yield?**

Forth does things a certain way for good reasons.

## License and support

F-Lower is free and open source under the Artistic License 2.0 (see attached).

The easiest way to contact me is via Mastodon, as [@felix@wandering.shop][2]. I'd like to hear from you anyway, but if you have any problems, it's best to open an issue [on Codeberg][3].

[2]: https://wandering.shop/@felix
[3]: https://codeberg.org/nosycat/f-lower
