program f_lower; {$mode objFPC} {$H+}

uses
	sysutils, contnrs, forth;
const
	help_text: array of string = (
		'Usage:',
		'    fl [ -h | -v | -q | -e CODE | -i FILE | PROGRAM ]',
		'',
		'Arguments:',
		'    PROGRAM:       run given program',
		'',
		'Options:',
		'    -h, --help:    show this message and quit',
		'    -v, --version: show version and quit',
		'    -q, --quiet:   suppress banner and prompt',
		'    -e, --exec:    evaluate given CODE and quit',
		'    -i, --include: include given FILE and go interactive');
var
	arg1, h: string;
	quiet: boolean = false;
	source_file: string;
	source_line: integer = 0;

procedure include(filename: string);
var
	old_file, line_in: string;
	old_line: integer;
	source: textfile;
begin
	old_file := source_file;
	old_line := source_line;
	source_file := filename;
	source_line := 0;
	assignfile(source, source_file);
	try
		reset(source);
		while not eof(source) do begin
			inc(source_line);
			readln(source, line_in);
			refill(line_in);
			interpret;
		end;
	finally
		closefile(source);
	end;
	source_file := old_file;
	source_line := old_line;
end;

procedure do_include;
var
	w: string;
begin
	w := input_buffer.shift;
	if w <> '' then
		include(w)
	else
		raise EForthError.create('Word name expected in include');
end;

begin
	def_builtin('include', @do_include);

	if paramcount > 0 then
	begin
		arg1 := paramstr(1); 
		if (arg1 = '-h') or (arg1 = '--help') then
			begin
				for h in help_text do
					writeln(h);
				halt;
			end
		else if (arg1 = '-v') or (arg1 = '--version') then
			begin
				writeln('F-Lower version ', version_string);
				halt;
			end
		else if (arg1 = '-q') or (arg1 = '--quiet') then
			begin
				quiet := true;
			end
		else if (arg1 = '-e') or (arg1 = '--exec') then
			try
				refill(paramstr(2));
				interpret;
				halt
			except
				on e: EConvertError do begin
					writeln(stderr, 'Conversion error: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
					halt(1);
				end;
				on e: EForthError do begin
					writeln(stderr, 'Forth error: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
					halt(2);
				end;
				on e: EInOutError do begin
					writeln(stderr, 'I/O error: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
					halt(3);
				end;
				on e: EDuplicate do begin
					writeln(stderr, 'Duplicate word: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
					halt(3);
				end;
			end
		else if (arg1 = '-i') or (arg1 = '--include') then
			try
				include(paramstr(2));
			except
				on e: EConvertError do begin
					writeln(stderr, 'Conversion error: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
				end;
				on e: EForthError do begin
					writeln(stderr, 'Forth error: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
				end;
				on e: EInOutError do begin
					writeln(stderr, 'I/O error: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
				end;
				on e: EDuplicate do begin
					writeln(stderr, 'Duplicate word: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
				end;
			end
		else
			try
				include(arg1);
				halt
			except
				on e: EConvertError do begin
					writeln(stderr, 'Conversion error: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
					halt(1);
				end;
				on e: EForthError do begin
					writeln(stderr, 'Forth error: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
					halt(2);
				end;
				on e: EInOutError do begin
					writeln(stderr, 'I/O error: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
					halt(3);
				end;
				on e: EDuplicate do begin
					writeln(stderr, 'Duplicate word: ', e.message);
					writeln('In ', source_file, ' line ', source_line);
					halt(3);
				end;
			end;
	end;

	if not quiet then begin
		writeln('Welcome to F-Lower v', version_string);
		writeln('Interpreter version: 2025-04-08');
		writeln('Enter code or `bye` to exit:');
	end;

	while not eof do begin
		refill;
		try
			interpret;
			if quiet then
				begin end
			else if state = buffering then
				writeln('...')
			else
				writeln('ok');
		except
			on e: EConvertError do begin
				writeln(stderr, 'Conversion error: ', e.message);
				writeln('In ', source_file, ' line ', source_line);
			end;
			on e: EForthError do begin
				writeln(stderr, 'Forth error: ', e.message);
				writeln('In ', source_file, ' line ', source_line);
			end;
			on e: EInOutError do begin
				writeln(stderr, 'I/O error: ', e.message);
				writeln('In ', source_file, ' line ', source_line);
			end;
			on e: EDuplicate do begin
				writeln(stderr, 'Duplicate word: ', e.message);
				writeln('In ', source_file, ' line ', source_line);
			end;
		end;
	end;	
end.
