' Lost in the Jungle: a silly little survival game.
' 2023-08-15 Felix Pleşoianu <https://felix.plesoianu.ro/>
' Based on the Nim edition. Use as you like, and enjoy!

enum colors
	black = 0
	green = 2
	gray = 7
	magenta = 13
	yellow = 14
	white = 15
end enum

var shared color_mode = false
var shared leave_game = false

var shared fatigue = 0.0
var shared health = 5.0
var shared bullets = 6

var shared skill = 0.15
var shared distance = 50.0
var shared hours = 0

dim shared chances(0 to 7) as double

sub startGame
	fatigue = 0.0
	health = 5.0
	bullets = 6

	skill = 0.15
	distance = 45 + int(rnd * 11)
	hours = 0

	for i as integer = 0 to 7
		chances(i) = 0.0
	next
end sub

function tiredness(fatigue as double, health as double) as string
	var energy = health - fatigue
	if energy <= 1 then
		return "drained"
	elseif energy <= 3 then
		return "tired"
	else
		return "fresh"
	end if
end function

function healthLevel(health as double) as string
	if health < 2 then
		return "bad"
	elseif health < 4 then
		return "decent"
	else
		return "good"
	end if
end function

sub setStatus(byref status1 as string, byref status2 as string)
	status1 = _
		"In " & healthLevel(health) & " health; " & _
		tiredness(fatigue, health) & _
		". Bullets: " & bullets & _
		". Time: " & hours & "h."
        if distance >= 35 then
                status2 = "Can't see the sky for the forest canopy."
        elseif distance >= 15 then
                status2 = "Shafts of sunlight mark the path ahead."
        else
                status2 = "The trees are growing farther apart now."
	end if
end sub

sub drawStatus(line1 as string, line2 as string)
	if color_mode then color white, black
	cls
	if color_mode then color yellow, green
	locate 1, 1
	print line1
	print line2
end sub

function menu(options() as string) as integer
	if color_mode then color white, black
	print
	for i as integer = lbound(options) to ubound(options)
		print i; ") "; options(i)
	next
	print
	dim result as integer
	do
		result = val(chr(getkey))
		if result = 0 then return result
	loop until result >= lbound(options) and result <= ubound(options)
	print
	return result
end function

declare sub doWalk
declare sub doRest

sub noEncounter
	print "Around you, the jungle looms."
	dim quiet_menu(1 to 2) as string = {"March on", "Get some rest"}
	select case as const menu(quiet_menu())
		case 0: leave_game = true
		case 1: doWalk
		case 2: doRest
	end select
end sub

sub doWalk
	if fatigue >= health then
		print "You can't take another step."
		doRest
	else
		var walked = health - fatigue
		distance -= walked
		fatigue += 1
		hours += 1
		if walked <= 1 then
			print "You crawl along tiredly."
		elseif walked <= 3 then
			print "You march on, making steady progress."
		else
			print "You advance quickly for now..."
		end if
	end if
end sub

declare sub itsVenomous
declare sub fightMonkeys

sub doRest
	hours += 1

	if health < 5 then
		health += 0.5
		if health > 5 then health = 5
		if fatigue >= health then
			fatigue -= 1
		else
			fatigue -= 0.5
		end if
		if fatigue < 0 then fatigue = 0
		print "You rest and heal a little."
	else
		if fatigue >= health then
			fatigue -= 2
		else
			fatigue -= 1
		end if
		if fatigue < 0 then fatigue = 0
		print "You get some good rest."
	end if
	select case rnd
		case is < 0.15
			print !"But while you were sleeping...\n"
			fightMonkeys
		case is < 0.3
			print !"But while you were sleeping...\n"
			itsVenomous
	end select
end sub

declare sub drinkWater
declare sub noDrinking

sub findWater
        print "You find a pool of water."
	dim water_menu(1 to 2) as string = {"Drink some", "Leave it"}
        select case as const menu(water_menu())
		case 0: leave_game = true
		case 1: drinkWater
		case 2: noDrinking
        end select
end sub

sub drinkWater
	fatigue -= 2
	if fatigue < 0 then fatigue = 0
	print "The water is cool. You feel refreshed."
	if rnd() >= skill then
		print "But drinking from the pool soon makes you ill."
		print "At least you learn the signs better."
		health -= 1
		skill += 0.05
	end if
end sub

sub noDrinking
        print "Better not chance taking a drink at this time."
end sub

declare sub eatFruit
declare sub noEating

sub findFruit
	print "You find strange fruit."
	dim fruit_menu(1 to 2) as string = {"Eat some", "Leave it"}
	select case as const menu(fruit_menu())
		case 0: leave_game = true
		case 1: eatFruit
		case 2: noEating
	end select
end sub

sub eatFruit
	health += 1
	if health > 5 then health = 5
	print "The fruit is tasty. You recover some strength."
	if rnd >= skill then
		print "But soon after eating it you feel drowsy."
		print "At least you learn the signs better."
		fatigue += 2
		skill += 0.05
	end if
end sub

sub noEating
	print "Better not chance taking a bite at this time."
end sub

declare sub shootGame
declare sub chaseGame
declare sub ignoreGame

sub huntGame
	dim critter(0 to 2) as string = { _
		"A small herbivore", "Some large rodent", "A flightless bird"}
	dim action(0 to 1) as string = { _
		" hears your steps and bolts.", " stumbles out of the bushes."}
	dim hunt_menu(1 to 3) as string = { _
		"Shoot it", "Run after it", "Just move on"}
	print critter(int(rnd * 3)); action(int(rnd * 2))
	select case as const menu(hunt_menu())
		case 0: leave_game = true
		case 1: shootGame
		case 2: chaseGame
		case 3: ignoreGame
	end select
end sub

declare sub eatGame

sub shootGame
	if bullets < 1 then
		print "Click! Click! No more bullets..."
		print "The lucky creature soon vanishes."
	else
		bullets -= 1
		print "You carefully take aim and... BANG!"
		eatGame
	end if
end sub

sub chaseGame
	if fatigue >= health then
		print "You're too tired to give chase."
	elseif rnd < skill then
		fatigue += 1
		print "You hunt it down and catch it."
		eatGame
	else
		fatigue += 1
		skill += 0.05
		print "You chase after it, but it's too fast."
		print "At least you learn new tricks."
	end if
end sub

sub eatGame
	hours += 1
	health += 2
	if health > 5 then health = 5
	print "Poor critter is tasty roasted on a tiny fire."
	print "You recover much of your strength."
end sub

sub ignoreGame
	print "You decide against playing hunter right now."
end sub

declare sub shootMonkeys
declare sub scareMonkeys
declare sub runAway

sub fightMonkeys
	print "Screaming monkeys come out of nowhere to harass you!"
	dim monkey_menu(1 to 3) as string = { _
		"Shoot at them", "Look scary", "Run away"}
	select case as const menu(monkey_menu())
		case 0: leave_game = true
		case 1: shootMonkeys
		case 2: scareMonkeys
		case 3: runAway
	end select
end sub

declare sub getMauled

sub shootMonkeys
	if bullets < 1 then
		print "Click! Click! No more bullets..."
		getMauled
	else
		bullets -= 1
		print "BANG! Your bullet goes crashing through the foliage."
		print "The monkeys scatter, shrieking even more loudly."
	end if
end sub

sub scareMonkeys
	print "You shout and wave a branch, trying to look bigger."
	if rnd < skill then
		print "The monkeys laugh mockingly at you as they scatter."
	else
		skill += 0.05
		print "It doesn't seem to be working very well at all."
		getMauled
	end if
end sub

sub getMauled
	health -= 2
	print "A rain of kicks and bites descends upon you!"
	print "At long last, the monkeys scatter, shrieking."
end sub

sub runAway
	hours += 1
	fatigue += 1 ' Should be less bad than what we're risking.
	print "You run away blindly, until your lungs burn."
	print "The chorus of shrieks slowly remains behind."
end sub

declare sub removeCrawlie
declare sub waitOutCrawlie

sub itsVenomous
	dim crawlie(0 to 2) as string = { _
		"giant centipede", "big hairy spider", "colorful snake"}
	print "A "; crawlie(int(rnd * 3)); " falls on you from above!"
	dim crawlie_menu(1 to 2) as string = { _
		"Remove it carefully", "Stand still"}
	select case as const menu(crawlie_menu())
		case 0: leave_game = true
		case 1: removeCrawlie
		case 2: waitOutCrawlie
	end select
end sub

sub removeCrawlie
	if rnd < skill then
		print "The crawlie wriggles wetly in your grasp. Yuck!"
	else
		skill += 0.05
		health -= 1.5
		print "You carefully try to pick up the crawlie, but... OW!"
		print "It bites! You're poisoned. Burns pretty badly, too."
	end if
	print "At least it's gone now. Hopefully."
end sub

sub waitOutCrawlie
	hours += 1
	fatigue += 1 ' Should be less bad than what we're risking.
	print "You wait tensely for what seems like hours."
	print "In the end, it's gone, and you're sweating."
end sub

declare sub restAtRuins
declare sub searchRuins
declare sub leaveRuins

sub findRuins
	print "You discover ancient ruins..."
	dim ruins_menu(1 to 3) as string = { _
		"Rest here", "Search the place", "Just move on"}
	select case as const menu(ruins_menu())
		case 0: leave_game = true
		case 1: restAtRuins
		case 2: searchRuins
		case 3: leaveRuins
	end select
end sub

sub restAtRuins
	fatigue -= 1
	if fatigue < 0 then fatigue = 0
	health += 1
	if health > 5 then health = 5
	hours += 2
	print "You sleep undisturbed for once, before moving on."
end sub

sub searchRuins
	hours += 1
	select case rnd
	case is < 0.3
		skill += 0.05
		print "You find old inscriptions teaching about the jungle."
	case is < 0.6
		print "You find gold and diamonds. Not much use right now."
	case else
		print "You find nothing of interest this time around."
	end select
end sub

sub leaveRuins
        hours += 1
        fatigue += 1
        distance -= 3 ' Not too much, because it's for free.
        print "You march on, emboldened, covering a good distance."
end sub

declare sub crossSwamp
declare sub avoidSwamp

sub reachSwamp
	print "A vast swamp bars your way."
	dim swamp_menu(1 to 2) as string = {"Risk a crossing", "Go around it"}
	select case as const menu(swamp_menu())
		case 0: leave_game = true
		case 1: crossSwamp
		case 2: avoidSwamp
	end select
end sub

sub crossSwamp
        if rnd < skill then
                print "Somehow you navigate the maze more or less safely."
        else
                ' Probably too harsh since you get tired either way.
                ' fatigue++;
                health -= 1
                skill += 0.05
                print "Mud pulls at your feet, and you nearly drown once."
                print "Mosquitos besiege you; their bites make you ill."
	end if
        hours += 1
        fatigue += 1
        distance -= 5
        print "It's a scary shortcut to take, but it saves a lot of travel."
end sub

sub avoidSwamp
        fatigue += 1.5 ' Should be bad, but not too bad.
        hours += 2
        print "A long, tiresome detour. Safe, but no closer to your goal."
end sub

declare sub shootPlant
declare sub wrestlePlant
declare sub cutPlant

sub triggerPlant
	print "Creeping vines entangle your limbs and drag you down."
	print "Oh no! It's a man-eating mandragore, and it's hungry!"
	dim plant_menu(1 to 3) as string = { _
		"Shoot it", "Wrestle free", "Cut the vines"}
	select case as const menu(plant_menu())
		case 0: leave_game = true
		case 1: shootPlant
		case 2: wrestlePlant
		case 3: cutPlant
	end select
end sub

declare sub getChewedOn

sub shootPlant
        if bullets < 1 then
                print "Click! Click! No more bullets..."
                getChewedOn
        else
                bullets -= 1
                print "BANG! You hit the plant's smelly flower dead center."
                print "It wilts away with a horrible squelching sound."
	end if
end sub

sub wrestlePlant
        var energy = (health - fatigue) * 2 / 10
        if rnd < energy then
                print "You vigorously pull at the vines, breaking a few."
                print "The plant soon decides to wait for easier prey."
        else
                print "You pull tiredly at the vines. It's not enough."
                getChewedOn
	end if
        fatigue += 1
end sub

sub cutPlant
        fatigue += 1
        if rnd < skill then
                print "You expertly hack at the vines with your knife."
                print "The plant soon decides to wait for easier prey."
        else
                skill += 0.05
                print "You clumsily hack at the vines with your knife."
                getChewedOn
	end if
end sub

sub getChewedOn
        health -= 1
        print "The plants chews on you with its toothless maw,";
	print " burning you with digestive juices before you escape."
end sub

dim shared encounters(0 to 7) as sub = { _
        @findWater, @findFruit, @huntGame, @fightMonkeys, _
        @itsVenomous, @findRuins, @reachSwamp, @triggerPlant}

function pickEncounter as sub
        for i as integer = 0 to 7
                if rnd < chances(i) then
                        chances(i) /= 5
                        return encounters(i)
                else
                        chances(i) += 0.05
		endif
	next
        return @noEncounter
end function

sub press_any_key
	if color_mode then color gray, black
	print : print "(press any key)"
	sleep : getkey
end sub

sub playGame
	while health > 0 and distance > 0
		dim status1 as string, status2 as string
		setStatus status1, status2
		drawStatus status1, status2
		if color_mode then color magenta, black
		print
		var encounter = pickEncounter()
		encounter()
		if leave_game then
			exit while
		else
			press_any_key
		end if
	wend

	print

	if health <= 0 then
		print "You died in the jungle, after ";
		print hours; " hours of struggle."
		print "No more than "; distance; "km away from safety."
		if bullets = 6 then
			print "Without as much as firing a single bullet."
		end if
		print "Oh well, better luck next time."
	elseif distance <= 0 then
		print "At last, the trees open up. You see a village. Saved!"
		print "Unless it's a hostile tribe? Just kidding. You win!"
		print "(In "; hours; " hours, with ";
		print bullets; " bullets left.)"
	else
		print "Game ended abnormally."
	end if
	
	press_any_key
end sub

sub showHelp
	drawStatus "Lost in the Jungle", "How to play"
	if color_mode then color magenta, black
	print
	print "The goal is to cross the 50Km or so separating you from safety."
	print "The exact distance varies every time you play."
	print
	print "Advance in the game by marching on whenever you get the chance."
	print "But you have to balance your health and fatigue."
	print
	print "The worse your health, the easier you get tired."
	print "It's not possible to die from exhaustion."
	print
	print "But being tired all the time will hold you up,"
	print "allowing more dangers to catch up with you and sap your health."
	print
	print "Hope this helps. Enjoy!"
	press_any_key
end sub

sub showIntro
	print "You survived the plane crash."
	print 
	print "With all your gear intact, too:"
	print 
	print "Gun, knife, compass, lighter."
	print 
	print "But you have no food or water."
	print 
	print "And a big bad jungle to cross."
end sub

randomize

dim game_menu(1 to 5) as string = {"Play", "Resume", "Color", "Help", "Quit"}

while true:
        drawStatus "Lost in the Jungle", "A game by No Time To Play"

        if color_mode then color magenta, black
        print : showIntro

        select case as const menu(game_menu())
		case 0
			print :	print "See you around!"
			exit while
		case 1
			leave_game = false
			startGame
			playGame
		case 2
			leave_game = false
			playGame
		case 3: color_mode = true
		case 4: showHelp
		case 5
			print : print "See you around!"
			exit while
        end select
wend

press_any_key
