# Batch Basic 3 quick reference

(This document applies to version 3.3, current as of 18 October 2025.)

Strings are delimited with double quotes; no escape characters.

As of version 3, identifiers can contain letters, digits, underscores and dollar signs, but can't start with a digit.

Keywords and identifiers are case-insensitive and become lowercase internally.

The `true` and `false` literals are parsed as 1 and 0, respectively.

## Statements

None of the statements are privileged, but some are defined only in stand-alone and/or interactive mode.

### Essentials

	rem text
	' text

Note: `rem` statements can appear in any position, but ' is only recognized in the first column of a line.

	print ?expression (, | ;) ...?
	let variable | array[index] = expression
	input ?string ,? variable ?, variable...?
	line input ?string ,? variable

### Control structures

	if condition then statement ?: statement...?

	test condition
	iftrue statement ?: statement...?
	iffalse statement ?: statement...?

	while condition
		...
	wend

	for variable = start to limit ?step step?
		...
	next ?variable?

	repeat
		...
	until condition

	do variable = start, limit ?, step?
		...
	done

	on expression gosub name ?, name ...?

### Subroutines

	sub name
		...
	return

	call name

~~(The `call` statement can be omitted if the subroutine name is alphabetic.)~~

### Miscellaneous

	data value ?, value...?
	read variable ?, variable...?
	restore index
	poke index, value
	eval expression

	randomize seed?

	dim array[size]
	redim ?preserve? array[size]
	erase name ?, name...?
	swap variable, variable

	option explicit
	option base index

### Stand-alone mode only

	merge filename
	quit
	environ$(s)

### Interactive mode only

	load filename
	clear
	new
	delete subroutine
	list ?subroutine?
	save filename

## Functions

* min(a, b), max(a, b)
* peek(n), expr(e), iif(cond, t, f)
* timer()

### Math functions

* abs(n), sgn(n), int(n), sqr(n), rnd()
* pi(), sin(), cos(n), deg(n), rad(n), hypot(a, b)
* e(), exp(n), log(n) 

### String functions

* len(s), val(s), asc(s)
* str$(v, ...), chr$(c, ...), space$(n)
* lcase$(s), ucase$(s)
* ltrim$(s), rtrim$(s), trim$(s)
* left$(s, n), right$(s, n), mid$(s, i, ?n?)
