#include <iostream>

#include "batchbas.hpp"

const Basic::Str test_suite[] = {
	"print \"Hello,\" \" world!\";",
	"PRINT",
	"print 1 + 2 + 3 + 4 - 5",
	"let TEST1 = .121 + 0.212",
	"print test1",
	"Print 5 * (3 + 2)",
	"print abs(-3.5)",
	"",
	"if 2 < 3 then print \"Yes!\": print \"It works!\" ",
	"if 2 > 3 then print \"Oops!\": rem Shouldn't happen.",
	"test 2 < 3",
	"iftrue print \"Yay!\"",
	"iffalse print \"Nay.\"",
	"",
	"sub test",
	"    print \"Hello, sub!\"",
	"return",
	// "test",
	"call test",
	"let i = 1",
	"while i <= 3",
	"    print i",
	"    let i = i + 1",
	"wend",
	"for j = 1 to 3",
	"    print j",
	"next j",
	"repeat",
	"    let j = j + 1",
	"    print j",
	"until j >= 6",
	"do j = 1,10,2",
	"    print j",
	"done",
	"data 1 + 2, 2 + 3, 3 + 4",
	"for d = 1 to 3",
	"    read e",
	"    print e",
	"next"
};

int main() {
	using namespace Basic;

	Context ctx;
	load_builtins(ctx);

	std::cout << sizeof(ctx) << " bytes\n";
	std::cout << ctx.statements.size() << " statements\n";
	std::cout << ctx.functions.size() << " functions" << std::endl;

	Str test = "TesT";
	lower_case(test);
	std::cout << test << std::endl;

	for (const auto& i: test_suite) {
		try {
			ctx.eval(i);
		} catch (const Basic::ParseError& e) {
			std::cerr << "Parsing error at: "
				<< ctx.line.substr(ctx.cursor) << "\n"
				<< e.what() << std::endl;
		} catch (const Basic::RunError& e) {
			std::cerr << "Runtime error at: "
				<< ctx.line.substr(ctx.cursor) << "\n"
				<< e.what() << std::endl;
		}
	}
}
