# Batch Basic 3 language guide

(This document applies to version 3.2.1 beta, current as of 2 October 2025.)

While Batch Basic should be familiar to many programmers, some aspects of the language don't work in the usual way.

## Strings, numbers and variables

Batch Basic 3 supports two data types: strings and numbers. It converts between them as needed, to keep things simple. That said, arithmetic operators always perform arithmetic:

	print "3" + "5" = 8
	' print "blah" + 1

The second line would error out, because "blah" isn't numeric. To concatenate strings, use the `str$` function or else the `&` operator:

	let result = str$("3 + 5 = ", 3 + 5)
	let result = "3 + 5 = " & 3 + 5

Comparison operators don't make conversions however:

	print 1 = "1"
	print 1 = val("1")

Variables are dynamically typed, and arrays can be heterogeneous. In other words, you can do this:

	let a = "Hello"
	let a$ = 3
	dim b[2]
	let b[0] = a
	let b[1] = a$

It's up to you to exercise type discipline.

**Caution: there's no way to escape a double quote in a string literal, so the `save` command can emit broken code. Use with care.**

## DATA and company

Batch Basic has `data`, `read` and `restore` statements, but they don't work quite like in other dialects.

For one thing, `data` is an executable statement, so it has to run before any values are made available to the program. On the plus side, `data` takes expressions, not just literals, and you can call it in a loop.

Due to the absence of line numbers or labels, `restore` takes an index number instead, starting at zero, which is also the default.

Internally, the values defined with `data` are stored in a vector, that can be accessed with `peek` and `poke`. In interactive mode, this vector is cleared on `new` or `load`.

## Arrays

As of version 2.4 beta, Batch Basic has arrays, but they can only have one dimension. They're zero-indexed by default and use square brackets:

	dim test[10]
	let test[0] = 5
	print test[0]
	redim test[20]
	let test[10] = 15

You can name an array the same as a scalar variable, but beware that `erase` will remove both of them.

In Batch Basic, `redim` always preserves array contents; `preserve` is redundant (but accepted for compatibility).
