# Intro to Batch Basic 3

The Basic programming language is alive and well in 2024, but putting a novel spin on it can be difficult.

Batch Basic is a structured dialect with no line numbers and a few quirks. It's not very useful by itself, and mainly intended to be embedded, or used as a basis for extension / customization. It supports both interactive use and running programs written in advance, and in fact doesn't make any difference between modes of operation internally.

This document applies to version 3.0 and later of Batch Basic.

## Building and running

Batch Basic is written in C++, using only the standard library. If you didn't receive a binary with this file, you can build it with a command like

	g++ batchbas.cpp -std=c++17 -O2 -o bb3

in the `src/` directory. A makefile is also included for convenience.

## Status and performance

Batch Basic 3 is mostly complete as of March 2024. It builds and runs, but needs more testing.

As of version 3.2 (October 2025), performance is almost on par with Batch Basic 2; see notes for that version.

## For developers

The interpreter is currently made of two parts: a single-header library that implements the data structures and a set of core statements / functions, and a main program that adds support for interactive and non-interactive use, as well as serving as an embedding example.

Batch Basic relies on direct interpretation and adds a minimum of new types. That creates limitations, but makes it easier to understand.

Source code for version 3.0 and later is written in C++17.

## License and support

Batch Basic 3 is open source under the Boost License (see inside).

The easiest way to contact me is via Mastodon, as [@felix@wandering.shop][1]. I'd like to hear from you anyway, but if you have any problems, it's best to open an issue [on Codeberg][2].

[1]: https://wandering.shop/@felix
[2]: https://codeberg.org/nosycat/bb3
