# Batch Basic 2 quick reference

(This document applies to version 2.7 beta, current as of 2 October 2025.)

Strings are delimited with double quotes; no escape characters.

As of version 2.5, identifiers can contain letters, digits and underscores, but can't start with a digit.

Keywords and identifiers are case-insensitive and become lowercase internally.

The `true` and `false` literals are parsed as -1 and 0, respectively.

## Statements

None of the statements are privileged, but some are defined only in stand-alone and/or interactive mode.

### Essentials

	rem text
	' text

Note: `rem` statements can appear in any position, but ' is only recognized in the first column of a line.

	print ?string | expression (, | ;) ...?
	let variable | array[index] = expression
	input ?string ,? variable ?, variable...?

### Control structures

	if condition then statement ?: statement...?

	test condition
	iftrue statement ?: statement...?
	iffalse statement ?: statement...?

	while condition
		...
	wend

	for variable = start to limit ?step step?
		...
	next ?variable?

	repeat
		...
	until condition

	do variable = start, limit ?, step?
		...
	done

	on expression gosub name ?, name ...?

### Subroutines

	sub name
		...
	return

	?call? name

(CALL can be omitted if the subroutine name is alphabetic.)

### Miscellaneous

	data value ?, value...?
	read variable ?, variable...?
	restore index
	poke index, value

	randomize seed?

	dim array[size]
	redim ?preserve? array[size]
	erase name ?, name...?
	swap name, name

	option explicit
	option base index

### Stand-alone mode only

	merge filename
	quit

### Interactive mode only

	load filename
	clear
	new
	delete subroutine
	list ?subroutine?
	save filename

## Functions

* abs(n), sgn(n), int(n), sqr(n)
* pi(), sin(), cos(n), deg(n), rad(n), hypot(a, b)
* min(a, b), max(a, b)
* e(), exp(n), log(n)
* peek(n), rnd(), timer()
