# Batch Basic 2 language guide

While Batch Basic should be familiar to many programmers, some aspects of the language don't work in the usual way.

## Strings, `print` and special characters

In Batch Basic 2, strings can't be stored in variables or otherwise manipulated, but only printed out. In other words, you can't do this:

	let greet$ = "Hello, world!"
	print greet$

but you can do this:

	print "Hello, world!"

To output special characters, there's a special construct:

	print "Hello, world"; chr$(33)

Note, that's not a function, and in fact you can also write it like this:

	print "Hello, world" chr$ 33

Indeed, Batch Basic is lenient about commas and the like, in many places.

## DATA and company

(This document applies to version 2.7 beta, current as of 2 October 2025.)

Batch Basic has `data`, `read` and `restore` statements, but they don't work quite like in other dialects.

For one thing, `data` is an executable statement, so it has to run before any values are made available to the program. On the plus side, `data` takes expressions, not just literals, and you can call it in a loop.

Due to the absence of line numbers or labels, `restore` takes an index number instead, starting at zero, which is also the default.

Internally, the values defined with `data` are stored in a vector, that can be accessed with `peek` and `poke`. In interactive mode, this vector is cleared on `new` or `load`.

## Arrays

As of version 2.4 beta, Batch Basic has arrays, but they can only have one dimension. They're zero-indexed by default and use square brackets:

	dim test[10]
	let test[0] = 5
	print test[0]
	redim test[20]
	let test[10] = 15

You can name an array the same as a scalar variable, but beware that `erase` will remove both of them.

In Batch Basic, `redim` always preserves array contents; `preserve` is redundant (but accepted for compatibility).
