# Intro to Batch Basic 2

The Basic programming language is alive and well in 2022, but putting a novel spin on it can be difficult.

Batch Basic is a structured dialect with no line numbers and a few quirks. It's not very useful by itself, and mainly intended to be embedded, or used as a basis for extension / customization. It supports both interactive use and running programs written in advance, and in fact doesn't make any difference between modes of operation internally.

A different language of the same name was intially prototyped, but didn't go anywhere and had to be completely rethought.

## Building and running

Batch Basic is written in C++, using only the standard library. If you didn't receive a binary with this file, you can build it with a command like

	g++ batchbas.cpp -std=c++11 -O2 -o bb2

in the `src/` directory. A makefile is also included for convenience.

## For developers

The interpreter is made of two parts: a single-header library that implements the data structures plus a set of core statements / functions, and a main program that adds support for interactive and non-interactive use, as well as serving as an embedding example.

Batch Basic relies on direct interpretation and adds a minimum of new types. That creates limitations, but makes it easier to understand.

Version 2.x source code is written in C++11; newer versions require more.

## Performance

An informal comparison using some classic benchmarks suggests that Batch Basic 2.7 is a little faster than Python 3.11, but a little slower than Tcl 8.6, especially when it comes to array access.

Keep in mind: these are quick, informal tests involving a simpler language.

## License and support

Batch Basic is free and open source under the Artistic License 2.0 (see inside).

The easiest way to contact me is via Mastodon, as [@felix@wandering.shop][1]. I'd like to hear from you anyway, but if you have any problems, it's best to open an issue [on Codeberg][2].

[1]: https://wandering.shop/@felix
[2]: https://codeberg.org/nosycat/bb2
