#!/usr/bin/env python3

from __future__ import print_function

from batchbas import *

print(str(len(builtins)) + " built-in functions.")

m = re_float.match("  1")
print(m.group(1))
m = re_string.match('"Hello, world!"')
print(m.group(1))

print(parse_line(Parser("  LET a = 1 + SQR(2)")))
print(parse_line(Parser('print "abc" + "def"')))

try:
	print(parse_line(Parser('print "abc" + 3')))
except TypeError as e:
	print(e)
except SyntaxError as e:
	print(e)

parser = Parser("if 1 < 2 then print 1 else print 2: 'comment")
try:
	print(parse_line(parser))
except Exception as e:
	print("In column " + str(parser.pos))
	print(e)


scope = Scope()
eval_line(parse_line(Parser('print "abc" + "def"')), scope, None)
eval_line(parse_line(Parser('let a$ = "abc"')), scope, None)
eval_line(parse_line(Parser('print a$ + "def"')), scope, None)

eval_line(parse_line(Parser("  PRINT 1 + SQR(2)")), scope, builtins)

eval_line(parse_line(Parser("PRINT 1 < 2")), scope, builtins)
eval_line(parse_line(Parser("PRINT 2 < 1")), scope, builtins)
eval_line(parse_line(Parser("PRINT 1 and 1")), scope, builtins)
eval_line(parse_line(Parser("PRINT 1 and 0")), scope, builtins)
