cdef public list statement_names

cdef class Parser:
	cdef public str text, token
	cdef public int pos
	cpdef bint match(self, re)
	cpdef bint peek(self, re)

cpdef public list parse_line(Parser parser)
cpdef public list parse_stmtlist(Parser parser)
cpdef public tuple parse_statement(Parser parser)
cpdef public tuple parse_print(Parser parser)

cpdef public bint at_stmt_end(Parser parser)

cpdef public tuple parse_let(Parser parser)

cpdef public tuple name2ref(str name)

cpdef public tuple parse_def(Parser parser)
cpdef public tuple parse_load(Parser parser)
cpdef public tuple parse_cd(Parser parser)
cpdef public tuple parse_if(Parser parser)
cpdef public tuple parse_while(Parser parser)
cpdef public tuple parse_data(Parser parser)
cpdef public tuple parse_read(Parser parser)
cpdef public tuple parse_restore(Parser parser)

cpdef public tuple parse_1str(Parser parser, statement)
cpdef public tuple parse_2str(Parser parser, statement)

cpdef public tuple parse_expression(Parser parser)
cpdef public tuple parse_iif(Parser parser)
cpdef public tuple parse_min(Parser parser)
cpdef public tuple parse_max(Parser parser)
cpdef public tuple parse_shell(Parser parser)
cpdef public tuple parse_path(Parser parser)
cpdef public tuple parse_disjunction(Parser parser)
cpdef public tuple parse_conjunction(Parser parser)
cpdef public tuple parse_negation(Parser parser)
cpdef public tuple parse_comparison(Parser parser)
cpdef public tuple parse_arithmetic(Parser parser)
cpdef public tuple parse_term(Parser parser)
cpdef public tuple parse_factor(Parser parser)
cpdef public tuple parse_value(Parser parser)

cpdef public list parse_exprlist(Parser parser)

cdef class Scope:
	cdef public dict names
	cdef public Scope parent

cpdef public void eval_line(list ast_list, Scope scope, dict functions)
cpdef public void eval_print(list expr_list, Scope scope, dict functions)
cpdef public void eval_let(tuple var, expr, Scope scope, dict functions)
cpdef public void eval_def(str name, list argnames, expr, scope, dict functions)

cpdef public void load_file(handle, Scope scope, dict functions)

cpdef public str read_file(str filename)

cpdef public void eval_cd(str dirname, Scope scope, dict functions)
cpdef public void eval_read(list varnames, Scope scope, dict functions)
cpdef public void eval_restore(int cursor, Scope scope, dict functions)

cpdef public eval_expr(tuple expr, Scope scope, dict functions)
cpdef public eval_funcall(str name, list args, Scope scope, dict functions)

cpdef public tuple make_builtin(t, list argnames, fn)

cdef public dict builtins
cdef public list data_store = []
cdef public int data_cursor = 0

cpdef public void repl(str banner, Scope scope, dict functions)

cdef public dict help_text = {}
