Batch Basic
===========


Batch Basic is an expression calculator based on the eponymous programming language, that emphasizes operators and functions over control structures, and delegates non-essential features to the operating system. It was created as an experiment in programming language design, but with the intent to make it useful anyway, at least for certain tasks, thanks to familiarity and focus.

The name comes from the fact that each line of code is interpreted exactly once, in order; there's no way to jump around, not even in scripts.

Features
--------

- Strings and numbers (64-bit floating point), with proper typechecking.
- 15 statements, 20 operators and 50 functions.
- Ability to run external programs and feed their output into calculations.

There's also a built-in help system that can be invoked from the interactive prompt.

Limitations
-----------

- There is no support for subroutines.
- Functions and control structures are strictly one-liners.
- Language constructs are focused on getting data into Batch Basic, not so much back out.

Status
------

As of 7 March 2017, Batch Basic is at the prototype stage, pending feedback. You'll need Python 3 installed to try it out. ~~Native and browser-based implementations are planned for the near future.~~

As of 30 October 2021, support for compiling with Cython has been added. No other changes were made.

Ultimately, Batch Basic proved overengineered, hard to implement in a less dynamic language, and a solution in search of a problem. It's now shelved.
