/*
 * Decompiled with CFR 0.152.
 */
package ro.plesoianu;

import java.util.Stack;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;
import ro.plesoianu.Data;
import ro.plesoianu.DirectoryItem;

public class PocketGopher
extends MIDlet
implements CommandListener,
ItemCommandListener {
    public final String[] itemTypeLabels = new String[]{"0 Text file", "1 Directory", "7 Search Query", "h Web page", "g GIF image", "I Image"};
    private Form top = new Form("Pocket Gopher");
    private Command nav_cmd = new Command("Go to...", 1, 10);
    private Command home_cmd = new Command("Home", 1, 10);
    private Command stop_cmd = new Command("Stop", 6, 5);
    private Command back_cmd = new Command("Back", 2, 5);
    private Command hist_cmd = new Command("History", 1, 10);
    private Command exit_cmd = new Command("Exit", 7, 10);
    private Command go_cmd = new Command("Go", 8, 5);
    private Command dir_pgup_cmd;
    private Command dir_pgdn_cmd;
    private ImageItem imgholder = null;
    private Ticker loading_notification = new Ticker("Loading...");
    private Alert item_fail = new Alert("Unsupported item type", "Pocket Gopher does not handle binary files.", null, AlertType.INFO);
    private Alert net_fail = new Alert("Failure", "Can't fetch the requested item", null, AlertType.ERROR);
    private Form bottom = null;
    private Command btm_close_cmd;
    private Command txt_pgup_cmd;
    private Command txt_pgdn_cmd;
    private Form navform = null;
    private Command goto_cmd;
    private Command nogo_cmd;
    private TextField url_fld;
    private TextField host_fld;
    private TextField port_fld;
    private ChoiceGroup type_fld;
    private TextField selector_fld;
    private StringItem nav_clear_fld;
    private Command nav_clear_cmd;
    private Form queryform = null;
    private Command query_cmd;
    private Command noqry_cmd;
    private TextField query_fld;
    private DirectoryItem queried_item;
    private Vector previous_dir = new Vector();
    private Vector current_dir = new Vector();
    private int dir_page_num = 0;
    private int dir_page_size = 25;
    private int dir_page_count = 0;
    private Stack history = new Stack();
    private Thread loading = null;
    private Vector current_text;
    private int txt_page_num = 0;
    private int txt_page_size = this.dir_page_size;
    private int txt_page_count = 0;

    public void startApp() {
        this.top.addCommand(this.nav_cmd);
        this.top.addCommand(this.home_cmd);
        this.top.addCommand(this.back_cmd);
        this.top.addCommand(this.hist_cmd);
        this.top.addCommand(this.exit_cmd);
        this.top.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.top);
        this.goHome();
        this.history.push(null);
        this.dir_pgup_cmd = new Command("PgUp", "Page Up", 1, 8);
        this.dir_pgdn_cmd = new Command("PgDn", "Page Down", 1, 8);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.stopLoading();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exit_cmd) {
            this.notifyDestroyed();
        } else if (command == this.home_cmd) {
            this.history.push(null);
            this.previous_dir = this.current_dir;
            this.goHome();
        } else if (command == this.stop_cmd) {
            this.stopLoading();
        } else if (command == this.back_cmd) {
            if (this.history.size() > 1) {
                this.history.pop();
                DirectoryItem directoryItem = (DirectoryItem)((Object)this.history.peek());
                this.current_dir = this.previous_dir;
                this.previous_dir = null;
                if (directoryItem == null) {
                    this.goHome();
                } else if (this.current_dir != null) {
                    this.setUpDirPagination(this.current_dir, this.top);
                    this.top.setTitle(directoryItem.hostname + " " + String.valueOf(directoryItem.port) + " " + directoryItem.selector);
                } else {
                    this.history.pop();
                    this.loadItem(directoryItem);
                }
            }
        } else if (command == this.hist_cmd) {
            if (this.bottom == null) {
                this.initSecondaryView();
            }
            this.bottom.deleteAll();
            this.addDirectoryToForm(this.history, this.bottom);
            this.bottom.setTitle("Session history");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.bottom);
        } else if (command == this.btm_close_cmd) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.top);
        } else if (command == this.nav_cmd) {
            if (this.navform == null) {
                this.initNavForm();
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.navform);
        } else if (command == this.goto_cmd) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.top);
            char c = this.itemTypeLabels[this.type_fld.getSelectedIndex()].charAt(0);
            DirectoryItem directoryItem = this.url_fld.getString().length() > 0 ? Data.parseGopherURL(this.url_fld.getString()) : new DirectoryItem(c, this.host_fld.getString(), this.selector_fld.getString(), this.host_fld.getString(), Integer.parseInt(this.port_fld.getString()));
            this.loadItem(directoryItem);
        } else if (command == this.nogo_cmd) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.top);
        } else if (command == this.query_cmd) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.top);
            this.queried_item.selector = this.queried_item.selector + "\t" + this.query_fld.getString();
            this.loadDirectory(this.queried_item);
        } else if (command == this.noqry_cmd) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.top);
        } else if (command == this.txt_pgdn_cmd) {
            if (this.txt_page_num < this.txt_page_count) {
                this.bottom.deleteAll();
                ++this.txt_page_num;
                this.paginateText(this.current_text, this.bottom, this.txt_page_num);
            }
        } else if (command == this.txt_pgup_cmd) {
            if (this.txt_page_num > 1) {
                this.bottom.deleteAll();
                --this.txt_page_num;
                this.paginateText(this.current_text, this.bottom, this.txt_page_num);
            }
        } else if (command == this.dir_pgdn_cmd) {
            if (this.dir_page_num < this.dir_page_count) {
                this.top.deleteAll();
                ++this.dir_page_num;
                this.paginateDir(this.current_dir, this.top, this.dir_page_num);
            }
        } else if (command == this.dir_pgup_cmd && this.dir_page_num > 1) {
            this.top.deleteAll();
            --this.dir_page_num;
            this.paginateDir(this.current_dir, this.top, this.dir_page_num);
        }
    }

    public void commandAction(Command command, Item item) {
        if (command == this.go_cmd) {
            this.loadItem((DirectoryItem)item);
        } else if (command == this.nav_clear_cmd) {
            this.url_fld.setString("");
            this.host_fld.setString("");
            this.port_fld.setString("70");
            this.type_fld.setSelectedIndex(1, true);
            this.selector_fld.setString("");
        }
    }

    public void loadItem(DirectoryItem directoryItem) {
        this.stopLoading();
        switch (directoryItem.getItemType()) {
            case '0': {
                this.loadTextFile(directoryItem);
                break;
            }
            case '1': {
                this.loadDirectory(directoryItem);
                break;
            }
            case '7': {
                this.loadQuery(directoryItem);
                break;
            }
            case 'h': {
                this.getURL(directoryItem.selector);
                break;
            }
            case 'I': 
            case 'g': {
                this.loadImage(directoryItem);
                break;
            }
            case 'i': {
                break;
            }
            default: {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.item_fail);
            }
        }
    }

    public void goHome() {
        this.stopLoading();
        this.current_dir = Data.parseDirectory(Data.slurpInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/home.txt")));
        this.top.setTitle("Pocket Gopher");
        this.top.deleteAll();
        this.addDirectoryToForm(this.current_dir, this.top);
    }

    public void stopLoading() {
        if (this.loading != null) {
            this.loading.interrupt();
            this.loading = null;
        }
        this.top.removeCommand(this.stop_cmd);
        this.top.setTicker(null);
    }

    public void getURL(String string) {
        try {
            this.platformRequest(string);
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.net_fail);
        }
    }

    public void show(Displayable displayable) {
        Display.getDisplay((MIDlet)this).setCurrent(displayable);
    }

    public void loadTextFile(final DirectoryItem directoryItem) {
        if (this.bottom == null) {
            this.initSecondaryView();
        }
        this.loading = new Thread(new Runnable(){

            public void run() {
                PocketGopher.this.top.setTicker(PocketGopher.this.loading_notification);
                PocketGopher.this.top.addCommand(PocketGopher.this.stop_cmd);
                String string = Data.fetchText(directoryItem.hostname, directoryItem.port, directoryItem.selector);
                if (string != null) {
                    PocketGopher.this.current_text = Data.splitString(string.replace('\r', '\n'), '\n');
                    PocketGopher.this.setUpTextPagination(PocketGopher.this.current_text, PocketGopher.this.bottom);
                    PocketGopher.this.bottom.setTitle(directoryItem.hostname + " " + String.valueOf(directoryItem.port) + " " + directoryItem.selector);
                    PocketGopher.this.show((Displayable)PocketGopher.this.bottom);
                } else {
                    PocketGopher.this.show((Displayable)PocketGopher.this.net_fail);
                }
                PocketGopher.this.top.removeCommand(PocketGopher.this.stop_cmd);
                PocketGopher.this.top.setTicker(null);
            }
        });
        this.loading.start();
    }

    public void loadDirectory(final DirectoryItem directoryItem) {
        this.loading = new Thread(new Runnable(){

            public void run() {
                PocketGopher.this.top.setTicker(PocketGopher.this.loading_notification);
                PocketGopher.this.top.addCommand(PocketGopher.this.stop_cmd);
                String string = Data.fetchText(directoryItem.hostname, directoryItem.port, directoryItem.selector);
                if (string != null) {
                    PocketGopher.this.history.push(new DirectoryItem(directoryItem));
                    PocketGopher.this.previous_dir = PocketGopher.this.current_dir;
                    PocketGopher.this.current_dir = Data.parseDirectory(string);
                    PocketGopher.this.setUpDirPagination(PocketGopher.this.current_dir, PocketGopher.this.top);
                    PocketGopher.this.top.setTitle(directoryItem.hostname + " " + String.valueOf(directoryItem.port) + " " + directoryItem.selector);
                    PocketGopher.this.show((Displayable)PocketGopher.this.top);
                } else {
                    PocketGopher.this.show((Displayable)PocketGopher.this.net_fail);
                }
                PocketGopher.this.top.removeCommand(PocketGopher.this.stop_cmd);
                PocketGopher.this.top.setTicker(null);
            }
        });
        this.loading.start();
    }

    public void loadImage(final DirectoryItem directoryItem) {
        if (this.bottom == null) {
            this.initSecondaryView();
        }
        this.loading = new Thread(new Runnable(){

            public void run() {
                PocketGopher.this.top.setTicker(PocketGopher.this.loading_notification);
                Image image = Data.fetchImage(directoryItem.hostname, directoryItem.port, directoryItem.selector);
                if (image != null) {
                    PocketGopher.this.bottom.deleteAll();
                    PocketGopher.this.bottom.setTitle(directoryItem.hostname + " " + String.valueOf(directoryItem.port) + " " + directoryItem.selector);
                    if (PocketGopher.this.imgholder == null) {
                        PocketGopher.this.initImageHolder(image);
                    } else {
                        PocketGopher.this.imgholder.setImage(image);
                    }
                    PocketGopher.this.bottom.append((Item)PocketGopher.this.imgholder);
                    PocketGopher.this.show((Displayable)PocketGopher.this.bottom);
                } else {
                    PocketGopher.this.show((Displayable)PocketGopher.this.net_fail);
                }
                PocketGopher.this.top.setTicker(null);
            }
        });
        this.loading.start();
    }

    public void loadQuery(DirectoryItem directoryItem) {
        this.queried_item = new DirectoryItem(directoryItem);
        if (this.queryform == null) {
            this.initQueryForm();
        }
        this.queryform.setTitle("Query: " + directoryItem.hostname + " " + String.valueOf(directoryItem.port) + " " + directoryItem.selector);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.queryform);
    }

    public void addDirectoryToForm(Vector vector, Form form) {
        if (vector == null || form == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.addDirItemToForm((DirectoryItem)((Object)vector.elementAt(i)), form);
        }
    }

    public void addDirItemToForm(DirectoryItem directoryItem, Form form) {
        if (directoryItem == null || form == null) {
            return;
        }
        if (directoryItem.getItemType() != 'i' && directoryItem.getItemType() != '3') {
            directoryItem.setDefaultCommand(this.go_cmd);
            directoryItem.setItemCommandListener(this);
        }
        form.append((Item)directoryItem);
    }

    public void setUpDirPagination(Vector vector, Form form) {
        this.dir_page_num = 1;
        this.dir_page_count = Data.numPages(vector.size(), this.dir_page_size);
        form.deleteAll();
        this.paginateDir(vector, form, 1);
        if (this.dir_page_count > 1) {
            form.addCommand(this.dir_pgup_cmd);
            form.addCommand(this.dir_pgdn_cmd);
        } else {
            form.removeCommand(this.dir_pgup_cmd);
            form.removeCommand(this.dir_pgdn_cmd);
        }
    }

    public void paginateDir(Vector vector, Form form, int n) {
        if (n < 1) {
            n = 1;
        } else if (n > this.dir_page_count) {
            n = this.dir_page_count;
        }
        int n2 = (n - 1) * this.dir_page_size;
        int n3 = n2 + this.dir_page_size;
        if (n3 > vector.size()) {
            n3 = vector.size();
        }
        String string = "Page " + String.valueOf(n) + " of " + String.valueOf(this.dir_page_count);
        form.append(string + "\n\n");
        for (int i = n2; i < n3; ++i) {
            this.addDirItemToForm((DirectoryItem)((Object)vector.elementAt(i)), form);
        }
        form.append("\n\n" + string);
    }

    public void setUpTextPagination(Vector vector, Form form) {
        this.txt_page_num = 1;
        this.txt_page_count = Data.numPages(vector.size(), this.txt_page_size);
        form.deleteAll();
        this.paginateText(vector, form, 1);
        if (this.txt_page_count > 1) {
            form.addCommand(this.txt_pgup_cmd);
            form.addCommand(this.txt_pgdn_cmd);
        } else {
            form.removeCommand(this.txt_pgup_cmd);
            form.removeCommand(this.txt_pgdn_cmd);
        }
    }

    public void paginateText(Vector vector, Form form, int n) {
        if (n < 1) {
            n = 1;
        } else if (n > this.txt_page_count) {
            n = this.txt_page_count;
        }
        int n2 = (n - 1) * this.txt_page_size;
        int n3 = n2 + this.txt_page_size;
        if (n3 > vector.size()) {
            n3 = vector.size();
        }
        String string = "Page " + String.valueOf(n) + " of " + String.valueOf(this.txt_page_count);
        form.append(string + "\n\n");
        for (int i = n2; i < n3; ++i) {
            form.append((String)vector.elementAt(i) + "\n");
        }
        form.append("\n\n" + string);
    }

    public void initNavForm() {
        this.navform = new Form("Navigate to...");
        this.goto_cmd = new Command("Go there", 4, 10);
        this.nogo_cmd = new Command("Cancel", 3, 10);
        this.url_fld = new TextField("Gopher URL", "", 140, 4);
        this.host_fld = new TextField("Hostname", "", 140, 4);
        this.port_fld = new TextField("Port", "70", 6, 2);
        this.type_fld = new ChoiceGroup("Item type", 4, this.itemTypeLabels, null);
        this.type_fld.setSelectedIndex(1, true);
        this.selector_fld = new TextField("Selector (optional)", "", 140, 4);
        this.nav_clear_fld = new StringItem(null, "Clear form", 2);
        this.nav_clear_cmd = new Command("Clear form", 1, 10);
        this.nav_clear_fld.setDefaultCommand(this.nav_clear_cmd);
        this.nav_clear_fld.setItemCommandListener((ItemCommandListener)this);
        this.navform.append((Item)this.url_fld);
        this.navform.append("Or else");
        this.navform.append((Item)this.host_fld);
        this.navform.append((Item)this.port_fld);
        this.navform.append((Item)this.type_fld);
        this.navform.append((Item)this.selector_fld);
        this.navform.append((Item)this.nav_clear_fld);
        this.navform.addCommand(this.goto_cmd);
        this.navform.addCommand(this.nogo_cmd);
        this.navform.setCommandListener((CommandListener)this);
    }

    public void initSecondaryView() {
        this.bottom = new Form("Pocket Gopher");
        this.btm_close_cmd = new Command("Close", 2, 5);
        this.txt_pgup_cmd = new Command("PgUp", "Page Up", 1, 10);
        this.txt_pgdn_cmd = new Command("PgDn", "Page Down", 1, 10);
        this.bottom.addCommand(this.btm_close_cmd);
        this.bottom.setCommandListener((CommandListener)this);
    }

    public void initImageHolder(Image image) {
        int n = 5123;
        this.imgholder = new ImageItem(null, image, n, "(image)");
    }

    public void initQueryForm() {
        this.queryform = new Form("Query server");
        this.query_cmd = new Command("Query", 4, 10);
        this.noqry_cmd = new Command("Cancel", 3, 10);
        this.query_fld = new TextField("Your query", "", 140, 0);
        this.queryform.append((Item)this.query_fld);
        this.queryform.addCommand(this.query_cmd);
        this.queryform.addCommand(this.noqry_cmd);
        this.queryform.setCommandListener((CommandListener)this);
    }
}

