-- $Name: Catch that cat$
-- $Version: 2020-05-18$
-- $Author: Felix Pleşoianu$
-- $Info: An interactive tech demo$

require "fmt"

game.act = "You see nothing special."
game.inv = "Hm, what to do with it."
game.use = "That's not very helpful."

stat {
	nam = "status";
	disp = function (s)
		p("Moves: ", time() - 1)
	end;
}

function init()
	take "status"
end

room {
	nam = "main";
	disp = "Catch that cat";
	dsc = [[
	Ugh. Monday morning. You're still not recovered after the party
	two days ago, and you have an SMS from your wife: 'Will stay
	with mom for one more day. You take the cat to the vet.' Meh.]];
	obj = {"start"};
}

obj {
	nam = "start";
	dsc = function (s)
		p(fmt.c "{An interactive tech demo}")
	end;
	act = function (s)
		walk("living", false, false)
	end;
}

room {
	nam = "living";
	disp = "Living room";
	dsc = "This is you one-room apartment in eastern Bucharest.";
	obj = {"couch", "TV", "table"};
	way = {"balcony", "kitchen", "hallway"};
}

couch = obj {
	nam = "couch";
	dsc = "A {worn-out couch} sags against the wall.";
	act = "You rest on the couch for a few moments. Aah, comfy!";
}

coffee = obj {
	nam = "table";
	dsc = "In front of the couch, a {coffee table} gets in the way.";
	obj = {"bottle", "remote"};
}

bottle = obj {
	nam = "bottle";
	disp = "beer bottle";
	dsc = "Oh! A {beer bottle} is lying around.";
	inv = "It's empty and sad.";
	tak = "You pick up the beer bottle.";
}

tv = obj {
	nam = "TV";
	dsc = "Over in the corner is the family's ancient {TV set}.";
	act = [[You look at the blank TV screen for a while.
		It's actually better than most channels.]];
}

obj {
	nam = "remote";
	disp = "remote control";
	dsc = "There's your {remote control}, too.";
	tak = "You pick up the remote control.";
	use = function (s, w)
		if w == tv then
			p [[Click! Click! The batteries must be dry.
			No wait, TV's broken.]]
		elseif w == coffee then
			p "You put the remote back on the table."
			drop "remote"
		elseif w == couch then
			p "You'll lose the remote. Again."
		else
			return false
		end
	end;
}

mitzi = obj {
	nam = "mitzi";
	disp = "Mitzi";
	dsc = "And {Mitzi} is present. As always.";
	act = "She's your black and white cat, young and energetic.";
	{
		ambient = {
			"Mitzi scampers about.";
			"Mitzi pounces a dust bunny.";
			"Mitzi chases her own tail.";
			"Mitzi races across the floor.";
			"Mitzi starts licking herself furiously.";
		}
	};
	mood = "playful";
	life = function (s)
		if here() == _ "ending" then
			return false
		elseif s.mood == "playful" then
			if here() == _ "main" then
				return false
			elseif where(s) == here() then
				p(s.ambient[rnd(#s.ambient)])
			else
				place(s, here())
				if here() == _ "ground" then
					place(s, "basement")
					s.mood = "hiding"
					p [[Mitzi squeezes through a hole
					in the door and into the basement.]]
				else
					p "Mitzi scampers after you."
				end
			end
		elseif s.mood == "hiding" then
			local light = _ "switch"
			if where(s) ~= here() then
				return false
			elseif light.is_on then
				p [[Mitzi peers at you from behind
					some water pipes.]]
			else
				p [[A pair of shining eyes stare at you
					from the darkness.]]
			end
		elseif s.mood == "carried" then
			p "Mitzi shuffles inside her carrier."
		end
	end;
	ini = function (s) lifeon(s) end;
}

room {
	nam = "balcony";
	disp = "Balcony";
	dsc = [[From the 11th floor you have a wonderful urban vista.
	Endless rows of apartment buildings everywhere you look.]];
	obj = {"broom"};
	way = {"living"};
}

broom = obj {
	nam = "broom";
	dsc = "There's a {broom} leaning against the wall.";
	inv = "An ordinary broom, and Mitzi's nemesis.";
	tak = "You pick up the broom.";
	use = function (s, w)
		if w == tv then
			p "You'll just break it worse than it already is."
		elseif w == coffee or w == couch then
			p "That's not how you clean the furniture!"
		elseif w == mitzi then
			if mitzi.mood == "playful" then
				p [[Mitzi stops for a moment
				and looks for her carrier.]]
			elseif mitzi.mood == "hiding" then
				local light = _ "switch"
				if not light.is_on then
					p [[Mitzi ignores the broom,
					believing you can't see her.]]
				elseif not have "carrier" then
					p [[Mitzi stops for a moment
					and looks for her carrier.]]
				else
					place(mitzi, "carrier")
					mitzi.mood = "carried"
					p [[Mitzi climbs into the cat
					carrier timidly.]]
				end
			else
				p "Mitzi already got in her carrier."
			end
		else
			return false
		end
	end;
}

room {
	nam = "kitchen";
	disp = "Kitchen";
	dsc = "Stacks of dirty dishes raise from every possible surface.";
	obj = {"crate"};
	way = {"living"};
}

crate = obj {
	nam = "crate";
	disp = "beer crate";
	dsc = "On the floor sits a {beer crate}.";
	inv = "A 12-slot beer crate with 11 empty bottles in it.";
	tak = "You pick up the beer crate. Oof.";
	used = function (s, w)
		if w == bottle then
			p "The last slot is broken and can't hold a bottle."
		else
			return false
		end
	end;
}

room {
	nam = "hallway";
	disp = "Hallway";
	dsc = [[There's hardly enough light to see, or room
		to turn around. Better watch your elbows.]];
	obj = {"inner-door"};
	way = {"living", "bathroom"};
}

keychain = obj {
	nam = "keychain";
	dsc = "Also {your keys} are here.";
	tak = "You pocket your keys.";
	use = function (s, w)
		if w == coffee then
			drop "keychain"
			p "You leave your keys on the table."
		elseif w == mitzi then
			if mitzi.mood == "playful" then
				p [[Mitzi is all too happy to play
					with the keys.]]
			else
				p "Mitzi tilts her head at you."
			end
		else
			return false
		end
	end;
}

obj {
	nam = "inner-door";
	dsc = "The {apartment door} looms ominously.";
	locked = true;
	act = function (s)
		if s.locked then
			p "It's locked. Now what did you do with the keys."
		else
			walk "11th-floor"
		end
	end;
	used = function (s, w)
		if w ~= keychain then
			return false
		elseif s.locked then
			p "The key turns smoothly, unlocking the door."
			s.locked = false
		else
			p "The key turns smoothly, locking the door."
			s.locked = true
		end
	end;
}

room {
	nam = "bathroom";
	disp = "Bathroom";
	dsc = [[A dim lightbulb, peeling paint, water on the floor.
		Home sweet home.]];
	obj = {"laundry"};
	way = {"hallway"};
}

obj {
	nam = "laundry";
	dsc = "In the corner there's a pile of {dirty laundry}.";
	ini = function (s)
		s:close()
	end;
	act = function (s)
		if s:closed() then
			s:open()
			p "Something rattles in the pile of laundry."
		else
			p "You find nothing else of interest."
		end
	end;
	obj = {"keychain"};
}

room {
	nam = "11th-floor";
	disp = "11th floor";
	obj = {"elevator-up", "outer-door"};
	way = {"ground"};
	onexit = function (s, t)
		if t ^ "ground" then
			p "You trot down the 11 flights of stairs. Sigh."
		end
	end;
	onenter = function (s, t)
		if t ^ "ground" then
			p "You trot up the 11 flights of stairs. Sigh."
		end
	end
}

obj {
	nam = "elevator-up";
	dsc = [[A battered {elevator} door stands next to the stairs
		leading down.]];
	act = [[You push the elevator's call button repeatedly.
		After a while, nothing seems to happen. How typical.]];
}

obj {
	nam = "outer-door";
	dsc = "Your {apartment door} huddles in a corner.";
	locked = false;
	act = function (s)
		if s.locked then
			p "It's locked. Now what did you do with the keys."
		else
			walk "hallway"
		end
	end;
	used = function (s, w)
		if w ~= keychain then
			return false
		elseif s.locked then
			p "The key turns smoothly, unlocking the door."
			s.locked = false
		else
			p "The key turns smoothly, locking the door."
			s.locked = true
		end
	end;
}

room {
	nam = "ground";
	disp = "Ground floor";
	obj = {"elevator-down", "base-door", "switch"};
	way = {"11th-floor", path {"Out in front", "outside"}}
}

obj {
	nam = "elevator-down";
	dsc = [[A battered {elevator} door stands next to the stairs
		leading up.]];
	act = [[You push the elevator's call button repeatedly.
		After a while, nothing seems to happen. How typical.]];
}

obj {
	nam = "base-door";
	dsc = "The {basement door} lurks under the stairs.";
	locked = true;
	act = function (s)
		if s.locked then
			p "It's locked. Now what did you do with the keys."
		else
			walk "basement"
		end
	end;
	used = function (s, w)
		if w ~= keychain then
			return false
		elseif s.locked then
			p "The key turns smoothly, unlocking the door."
			s.locked = false
		else
			p "The key turns smoothly, locking the door."
			s.locked = true
		end
	end;
}

light = obj {
	nam = "switch";
	dsc = "There's a {light switch} by the basement door.";
	broken = true;
	is_on = false;
	act = function (s)
		if s.broken then
			p "The light switch is hanging by a wire."
		elseif s.is_on then
			s.is_on = false
			p "You flip the light switch off."
		else
			s.is_on = true
			p "You flip the light switch on."
		end
	end;
}

room {
	nam = "basement";
	disp = "Basement";
	dsc = function (s)
		if light.is_on then
			p [[A vast room, silent and damp, subdivided
			by flimsy plywood walls. Ridiculously, big
			padlocks adorn stall doors a kid could break.]]
		else
			p "It's too dark to see much at all."
		end
	end;
	way = {"ground"};
}

room {
	nam = "outside";
	disp = "Outside your apartment building";
	dsc = [[A narrow backstreet meanders among 12-story
		apartment buildings. Trees and lamp posts rise
		from grass beds along the sidewalk;
		there's a corner store across the street.]];
	obj = {"car"};
	way = {"ground", "store"};
}

car = obj {
	nam = "car";
	dsc = "{Your car} is parked nearby.";
	ini = function (s) s:close() end;
	working = false;
	act = function (s)
		p "A second-hand Dacia 1310, almost an antique now."
		if s.working then
			p "It's been sitting in the sun, so now it's hot."
		else
			p [[It's been sitting in the sun, so now it's hot
				and... Oh no, you have a flat tire.]]
		end
	end;
	used = function (s, w)
		if w ~= keychain then
			return false
		elseif s:closed() then
			s:open()
			p "Aha! You knew you forgot something in the car."
		else
			p [[You play with the remote and double-check
				the doors. Everything seems fine.]]
		end
	end;
	obj = {"carrier"};
}

carrier = obj {
	nam = "carrier";
	disp = "cat carrier";
	dsc = "{Mitzi's carrier} is sitting here.";
	tak = "You pick up Mitzi's carrier.";
	ini = function (s) s:close() end;
	inv = function (s)
		if where(mitzi) == s then
			p "Mitzi is tucked safely inside."
		else
			p "Mitzi's carrier is rather empty."
		end
	end;
	use = function (s, w)
		if w == mitzi then
			if mitzi.mood == "hiding" then
				if not light.is_on then
					p "You can't even see her well."
					return true
				end
			end
			p "Mitzi turns her nose at the carrier. Nyu!"
		elseif w == coffee then
			p "You'll just scratch the furniture."
		elseif w == car then
			if not car.working then
				p "You should fix the car first."
			elseif where(mitzi) == s then
				drop "carrier"
				walk "ending"
			else
				drop "carrier"
				p "You put the carrier back for now."
			end
		else
			return false
		end
	end;
	used = function (s, w)
		if w == keychain then
			p "Mitzi's carrier only has a simple latch."
		else
			return false
		end
	end;
}

store = room {
	nam = "store";
	disp = "Corner store";
	dsc = [[Actually a converted ground floor apartment,
		but it does the job.]];
	obj = {"counter", "neighbor", "toolkit"};
	way = {path {"Out in front", "outside"}};
	onenter = '"Hello, neighbor. Can I get you anything?"';
}

counter = obj {
	nam = "counter";
	dsc = [[A {counter} with a tiny cash register on it sits
		in front of shelves containing mostly groceries.]];
	bottles = 0;
	used = function (s, w)
		if w == bottle then
			remove "bottle"
			s.bottles = s.bottles + 1
			p [[You put the bottle on the counter.
			"I believe you wanted this back?"
			^^Mr. Petrescu takes it in the back.
			"Yes, indeed. Thank you, neighbor."]]
		elseif w == crate then
			remove "crate"
			s.bottles = s.bottles + 11
			p [[You carefully set the crate down
			by the counter.
			"I believe you wanted this back?"
			^^Mr. Petrescu takes it in the back.
			"Yes, indeed. Thank you, neighbor."]]
		else
			p [["Please don't leave your things
			lying around, neighbor", says Mr. Petrescu.]]
		end
	end;
}

neighbor = obj {
	nam = "neighbor";
	dsc = "Behind the counter is {Mr. Petrescu}.";
	act = "Your portly, balding, middle-aged neighbor and store owner.";
	{
		ambient = {
			[[Mr. Petrescu idly rearranges
				some bottles on the shelves.]];
			[[Mr. Petrescu updates a few price labels.]];
			[[Mr. Petrescu taps his foot lightly
				and hums a little song.]];
			[[Mr. Petrescu fumbles under the counter.]];
			[[Mr. Petrescu fiddles with the cash register.]];
		}
	};
	life = function (s)
		if here() == store then
			p(s.ambient[rnd(#s.ambient)])
		end
	end;
	ini = function (s) lifeon(s) end;
	bottles = 0;
	used = function (s, w)
		if w == bottle then
			remove "bottle"
			s.bottles = s.bottles + 1
			p [[You put the bottle on the counter.
			"I believe you wanted this back?"
			^^Mr. Petrescu takes it in the back.
			"Yes, indeed. Thank you, neighbor."]]
		elseif w == crate then
			remove "crate"
			s.bottles = s.bottles + 11
			p [[You carefully set the crate down
			by the counter.
			"I believe you wanted this back?"
			^^Mr. Petrescu takes it in the back.
			"Yes, indeed. Thank you, neighbor."]]
		elseif w == broom or w == carrier then
			p [["Trouble with your cat?"
			Mr. Petrescu waves a hand dismissively.
			"Show her a broom and she'll know to behave."]]
		else
			return false
		end
	end;
}

obj {
	nam = "toolkit";
	dsc = "A {fancy toolkit} sits against the wall.";
	inv = [[A big portable toolkit, of the kind they sell
		for car repairs.]];
	tak = function (s)
		pn [["Say, neighbor," you ask, "can I borrow your tools?"^]]
		if counter.bottles + neighbor.bottles >= 12 then
			p [[Mr. Petrescu gestures towards the toolkit.
			"Help yourself. Just take care of it, will you?"]]
		else
			p [["Not so fast," says Mr. Petrescu,
			"Where is my beer crate?
			I need to return all the empty bottles."]]
			return false
		end
	end;
	use = function (s, w)
		if w == tv then
			p [[You tried that with the old TV.
				That's why you have a new one.]]
		elseif w == light then
			if w.broken then
				w.broken = false
				p [[You set to work, grumbling and mumbling.^^
				There, fixed. Not for the first time, either.]]
			else
				p "It's in mint condition now, thankfully."
			end
		elseif w == car then
			if w.working then
				p "You've already changed the tire."
			else
				w.working = true;
				p [[You set to work changing the tire,
				sweating heavily.^^It seems to take much
				longer than it actually does.]]
			end
		elseif w == coffee then
			p "You'll just scratch the furniture."
		elseif w == counter or w == neighbor then
			drop "toolkit"
			p [["Already done with it, neighbor?"
			asks Mr. Petrescu. "You're welcome!"]]
		else
			return false
		end
	end;
}

room {
	nam = "ending";
	disp = "Victory!";
	dsc = function (s)
		pn [[You load Mitzi's carrier in the car, and drive off to
		see the vet. About halfway there, you run out of gas.^]]
		p(fmt.c(fmt.b("*** You have won! ***")))
	end;
}
